﻿using System.Threading.Tasks;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Functions.Configuration.Interface
{
    public interface IIwsConfiguration
    {
        Task<string> GetBlobNameAsync();
        
        Task<string> GetResponseQueueNameAsync();
        
        Task<string> GetConnectionAsync();

        Task<string> GetOrgClientIdAsync();

        Task<string> GetOrgClientSecretAsync();

        Task<string> GetOrgBaseAsync();

        Task<UrlPacket> GetCcnInitialDataRequestUrlAsync();

        Task<string> GetResponseDocumentPathPatternAsync();

        Task<string> GetResponseDocumentReferenceUrlAsync();

        Task<string> GetPpmsXrmServicesUriAsync();

        Task<string> GetPpmsApiUriAsync();

        Task<string> GetPpmsResponseNotificationUriAsync(bool IsVaProvider = false);

        Task<string> GetPpmsResponsePostUriAsync(bool IsVaProvider = false);

        Task<string> GetCcnDocRefQueueNameAsync();

        Task<SchemaProfile> GetSchemaProfileAsync(SchemaOptions.SchemaProfiles profile);

        Task<string> GetPpmsDasIdentifierAsync();

        Task<string> GetNpiStatusTableNameAsync();

        Task<string> GetActivityHistoryTableNameAsync();

        Task<string> GetProviderPayloadQueueAsync();

        Task<string> GetNppesTargetUri();

        Task<string> GeTargetName(string target);

        Task<string> GetDasCertUrl();

        Task<string> GetDasAppId();

        Task<string> GetDasSecret();

        Task<string> GetAddressValidationCertUrl();

        Task<string> GetAddressValidationAppId();

        Task<string> GetAddressValidationSecret();

        Task<string> GetAddressValidationBaseUri();

        Task<string> GetAddressValidationRequestUri();

        Task<string> GetUsePieSecurity();

        Task<string> GetAzureAdAuthority();

        Task<string> GetPieAppRegResource();

        Task<PayloadProcessingSetting> GetPayloadProcessingParametersAsync();
    }
}